# 买卖股票的最佳时机 II

<p>给定一个数组 <code>prices</code> ，其中 <code>prices[i]</code> 是一支给定股票第 <code>i</code> 天的价格。</p>

<p>设计一个算法来计算你所能获取的最大利润。你可以尽可能地完成更多的交易（多次买卖一支股票）。</p>

<p><strong>注意：</strong>你不能同时参与多笔交易（你必须在再次购买前出售掉之前的股票）。</p>

<p> </p>

<p><strong>示例 1:</strong></p>

<pre>
<strong>输入:</strong> prices = [7,1,5,3,6,4]
<strong>输出:</strong> 7
<strong>解释:</strong> 在第 2 天（股票价格 = 1）的时候买入，在第 3 天（股票价格 = 5）的时候卖出, 这笔交易所能获得利润 = 5-1 = 4 。
     随后，在第 4 天（股票价格 = 3）的时候买入，在第 5 天（股票价格 = 6）的时候卖出, 这笔交易所能获得利润 = 6-3 = 3 。
</pre>

<p><strong>示例 2:</strong></p>

<pre>
<strong>输入:</strong> prices = [1,2,3,4,5]
<strong>输出:</strong> 4
<strong>解释:</strong> 在第 1 天（股票价格 = 1）的时候买入，在第 5 天 （股票价格 = 5）的时候卖出, 这笔交易所能获得利润 = 5-1 = 4 。
     注意你不能在第 1 天和第 2 天接连购买股票，之后再将它们卖出。因为这样属于同时参与了多笔交易，你必须在再次购买前出售掉之前的股票。
</pre>

<p><strong>示例 3:</strong></p>

<pre>
<strong>输入:</strong> prices = [7,6,4,3,1]
<strong>输出:</strong> 0
<strong>解释:</strong> 在这种情况下, 没有交易完成, 所以最大利润为 0。</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= prices.length <= 3 * 10<sup>4</sup></code></li>
	<li><code>0 <= prices[i] <= 10<sup>4</sup></code></li>
</ul>

<p>以下错误的选项是？</p>

## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    vector<int> prices = {1, 2, 3, 4, 5};

    int res;
    res = sol.maxProfit(prices);
    cout << res;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    int maxProfit(vector<int> &prices)
    {

        int dp[prices.size()][2];
        dp[0][0] = 0;
        dp[0][1] = -prices[0];
        for (int i = 1; i < prices.size(); i++)
        {
            dp[i][0] = max(dp[i - 1][0], dp[i][1] + prices[i]);
            dp[i][1] = max(dp[i - 1][0] - prices[i], dp[i][1]);
        }
        return dp[prices.size() - 1][0];
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    int maxProfit(vector<int> &prices)
    {
        int len = prices.size();
        int mpro = 0;
        if (len < 2)
            return 0;
        for (int i = 0; i < len - 1; i++)
        {
            if (prices[i + 1] > prices[i])
            {
                mpro += prices[i + 1] - prices[i];
            }
        }
        return mpro;
    }
};
```

### B
```cpp
class Solution
{
public:
    int maxProfit(vector<int> &prices)
    {
        int valley, peak, maxProfit = 0, index = 0;
        int len = prices.size();
        while (index < len - 1)
        {
            while (index < prices.size() - 1 && prices[index] >= prices[index + 1])
                index++;
            valley = prices[index];
            while (index < prices.size() - 1 && prices[index] <= prices[index + 1])
                index++;
            peak = prices[index];
            maxProfit += peak - valley;
        }
        return maxProfit;
    }
};
```

### C
```cpp
class Solution
{
public:
    int maxProfit(vector<int> &prices)
    {
        int profit = 0;
        for (auto i = prices.begin(); i != prices.end(); ++i)
            if (i + 1 != prices.end() && *(i + 1) > *i)
                profit += *(i + 1) - *i;
        return profit;
    }
};
```
